/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.recipe.ingredient;

import at.petrak.hexcasting.common.recipe.ingredient.StateIngredient;
import at.petrak.hexcasting.common.recipe.ingredient.StateIngredientTag;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;

public class StateIngredientTagExcluding
extends StateIngredientTag {
    private final List<StateIngredient> excludes;

    public StateIngredientTagExcluding(class_2960 id, Collection<StateIngredient> excludes) {
        super(id);
        this.excludes = List.copyOf(excludes);
    }

    @Override
    public boolean test(class_2680 state) {
        if (!super.test(state)) {
            return false;
        }
        return this.isNotExcluded(state);
    }

    @Override
    public class_2680 pick(Random random) {
        List<class_2248> blocks = this.getBlocks();
        if (blocks.isEmpty()) {
            return null;
        }
        return blocks.get(random.nextInt(blocks.size())).method_9564();
    }

    private boolean isNotExcluded(class_2680 state) {
        for (StateIngredient exclude : this.excludes) {
            if (!exclude.test(state)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o) && this.excludes.equals(((StateIngredientTagExcluding)o).excludes);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public JsonObject serialize() {
        JsonObject object = new JsonObject();
        object.addProperty("type", "tag_excluding");
        object.addProperty("tag", this.getTagId().toString());
        JsonArray array = new JsonArray();
        for (StateIngredient exclude : this.excludes) {
            array.add((JsonElement)exclude.serialize());
        }
        object.add("exclude", (JsonElement)array);
        return object;
    }

    @Override
    public List<class_1799> getDisplayedStacks() {
        return this.getBlocks().stream().filter(b -> b.method_8389() != class_1802.field_8162).map(class_1799::new).toList();
    }

    @Override
    @NotNull
    protected List<class_2248> getBlocks() {
        return super.getBlocks().stream().filter(b -> this.isNotExcluded(b.method_9564())).toList();
    }

    @Override
    public List<class_2680> getDisplayed() {
        return super.getDisplayed().stream().filter(this::isNotExcluded).toList();
    }
}

